// Do stuff if the document is fully loaded
$(document).ready(function() {	
	// Show an error message if the API key file is not loaded
	if (typeof API_Key === "undefined") {
		$("body").html("No API Key found<br>Rightclick on the script in Streamlabs Chatbot and select \"Insert API Key\"");
		$("body").css({"font-size": "20px", "color": "#ff8080", "text-align": "center"});
	}
	// Connect to the Streamlabs Chatbot websocket
	else {
		connectWebsocket();
	}
});

// Function to connect and authenticate to the Streamlabs Chatbot webosocket
// Automatically tries to reconnect after connection has been closed
// Handles received registered websocket events from Streamlabs Chatbot
function connectWebsocket() {
	// Create the websocket connection
	var socket = new WebSocket("ws://127.0.0.1:3337/streamlabs");
	// WS OnOpen event : authenticate
	socket.onopen = function() {
		// Create authentication payload and request required events
		var auth = {
			author: "Ocgineer",
			website: "http://www.twitch.tv/ocgineer",
			api_key: API_Key,
			events: [
				"EVENT_NOW_PLAYING"
			]
		};
		// Send authentication payload to Streamlabs Chatbot
		socket.send(JSON.stringify(auth));
	};

	// Ws OnClose : try reconnect
	socket.onclose = function() {
		socket = null;
		setTimeout(connectWebsocket, 5000);
	} 
	// WS OnMessage event : handle events
	socket.onmessage = function(message) {	
		// Parse message data to extract event name
		var socketMessage = JSON.parse(message.data);
		// EVENT_NOW_PLAYING
		if (socketMessage.event == "EVENT_NOW_PLAYING") {
			AnimateNewSong(JSON.parse(socketMessage.data))
		}
	}
};

function AnimateNewSong(data) {
	// Queue animation
	$("#song").queue(function() {
		$("#title").html(data.Title);
		$(this).removeClass("slideOutUp initialHide");
		$(this).addClass("slideInLeft");
		$(this).dequeue();
	})
	.delay(8000)
	.queue(function() {
		$(this).removeClass("slideInLeft");
		$(this).addClass("slideOutUp");
		$(this).dequeue();
	});
	// No delay added to wait for the slideOutUp
	// animation, this way in case of a song
	// skip it doesnt have to slide out first
};