#!/usr/bin/python
# -*- coding: utf-8 -*-

#---------------------------------------
# Import Libraries
#---------------------------------------
import clr
clr.AddReference("IronPython.SQLite.dll")
clr.AddReference("IronPython.Modules.dll")

import os
import codecs
import json
import time
import collections

#---------------------------------------
# Script Information
#---------------------------------------
ScriptName = "Welcome Mat"
Website = "http://www.digital-programming.de"
Description = "Says HI! to every new viewer! - Show viewer list: !showviewer [from] [to] - Show welcome messages: !showmessages"
Creator = "Kryptolyser"
Version = "1.0.0.1"

#---------------------------------------
# Variables
#---------------------------------------
CustomSettingsFile = os.path.join(os.path.dirname(__file__), "customSettings.json")
isEnabled = True
AddMessage = ""
DeleteMessage = 0
SendMessages = True
SafeQuestion = False
DeleteViewer = ""
ChatViewers = "!showviewer"
ChatMessages = "!showmessages"
ChatPermission = "Moderator"
ChatInfo = ""

#---------------------------------------
# Classes
#---------------------------------------
class Settings(object):
	""" Load in saved settings file if available else set default values. """
	def __init__(self, CustomSettingsFile=None):
		try:
			with codecs.open(CustomSettingsFile, encoding="utf-8-sig", mode="r") as f:
				self.__dict__ = json.load(f, encoding="utf-8")
		except:
			self.messages = ["Welcome to the community {viewer}!"]
			self.viewers = {}

	def Reload(self, jsondata):
		""" Reload settings from AnkhBot user interface by given json data. """
		self.__dict__ = json.loads(jsondata, encoding="utf-8")
		return

	def Save(self, CustomSettingsFile):
		""" Save settings contained within to .json and .js settings files. """
		with codecs.open(CustomSettingsFile, encoding="utf-8-sig", mode="w+") as f:
			json.dump(self.__dict__, f, encoding="utf-8", ensure_ascii=False, indent=4, sort_keys=True)
		#Parent.Log(ScriptName, "The settings file could not be saved!")
		return

#---------------------------------------
# Initialize Data on Load
#---------------------------------------
def Init():
	global ScriptSettings
	
	ScriptSettings = Settings(CustomSettingsFile)
	return

#---------------------------------------
# Reload Settings on Save
#---------------------------------------
def ReloadSettings(jsondata):
	global ScriptSettings, AddMessage, DeleteMessage, SendMessages, SafeQuestion, ViewerToDelete, ChatViewers, ChatMessages, ChatPermission, ChatInfo

	UISettings = Settings(CustomSettingsFile)
	UISettings.Reload(jsondata)
	AddMessage = UISettings.AddMessage
	DeleteMessage = UISettings.DeleteMessage
	SendMessages = UISettings.SendMessages
	SafeQuestion = UISettings.SafeQuestion
	ViewerToDelete = UISettings.ViewerToDelete
	ChatViewers = UISettings.ChatViewers
	ChatMessages = UISettings.ChatMessages
	ChatPermission = UISettings.ChatPermission
	ChatInfo = UISettings.ChatInfo
	
	if AddMessage.replace(" ", "") != "" and AddMessage not in ScriptSettings.messages:
		ScriptSettings.messages.append(AddMessage)
		Parent.Log(ScriptName, "Succsessfully added the message: {0}".format(AddMessage))
		ScriptSettings.Save(CustomSettingsFile)
	if DeleteMessage != 0:
		if DeleteMessage <= len(ScriptSettings.messages):
			Parent.Log(ScriptName, "Succsessfully removed the message: {0}".format(ScriptSettings.messages[DeleteMessage - 1]))
			del ScriptSettings.messages[DeleteMessage - 1]
			ScriptSettings.Save(CustomSettingsFile)
		else:
			Parent.Log(ScriptName, 	"There is no message with the ID {0}!".format(DeleteMessage))
	return

#---------------------------------------
#	Script is going to be unloaded
#---------------------------------------
def Unload():
	ScriptSettings.Save(CustomSettingsFile)
	return

#---------------------------------------
#	Script is enabled or disabled on UI
#---------------------------------------
def ScriptToggled(state):
	global ScriptSettings, isEnabled

	if not state:
		ScriptSettings.Save(CustomSettingsFile)
		isEnabled = False
	else:
		isEnabled = True
	return

#---------------------------------------
# Execute data and process messages
#---------------------------------------
def Execute(data):
	global ScriptSettings, ChatViewers, ChatMessages, ChatPermission, ChatInfo

	if data.IsChatMessage() and (ChatViewers.lower() in data.Message.lower() or data.Message.lower() == ChatMessages.lower()): 
		if Parent.HasPermission(data.User, ChatPermission, ChatInfo):
			if data.IsFromTwitch():
				if data.GetParam(0).lower() == ChatViewers.lower():
					if len(ScriptSettings.viewers) == 0:
						Parent.SendTwitchWhisper(data.User, "There are no viewers in the list!")
					else:
						if data.GetParamCount() == 3 and data.GetParam(1).isdigit() and data.GetParam(2).isdigit():
							Parent.SendTwitchWhisper(data.User, "Here are the viewers with there join date from {0} to {1} (totally {2}):".format(data.GetParam(1), data.GetParam(2), len(ScriptSettings.viewers)))
							ordered = collections.OrderedDict(sorted(ScriptSettings.viewers.items()))
							message = ""
							for i in range(int(data.GetParam(1)), int(data.GetParam(2))):
								key = GetKeyByIndex(ordered, i)
								message += "{0} ({1}), ".format(key, ordered[key])
							Parent.SendTwitchWhisper(data.User, message[:-2])
						else:
							Parent.SendTwitchWhisper(data.User, "Here are all {0} viewers:".format(len(ScriptSettings.viewers)))
							ordered = collections.OrderedDict(sorted(ScriptSettings.viewers.items()))
							message = ""
							for key, time in ordered.iteritems():
								message += "{0} ({1}), ".format(key, time)
							Parent.SendTwitchWhisper(data.User, message[:-2])
				elif data.Message.lower() == ChatMessages.lower():
					if len(ScriptSettings.messages) == 0:
						Parent.SendTwitchWhisper(data.User, "There are no welcome messages!")
					else:
						Parent.SendTwitchWhisper(data.User, "There are {0} welcome message(s):".format(len(ScriptSettings.messages)))
						counter = 1
		
						for message in ScriptSettings.messages:
							Parent.SendTwitchWhisper(data.User, "{0}. {1}".format(str(counter), message))
							counter += 1
			elif data.IsFromDiscord():
				if data.GetParam(0).lower() == ChatViewers.lower():
					if len(ScriptSettings.viewers) == 0:
						Parent.SendDiscordDM(data.User, "There are no viewers in the list!")
					else:
						if data.GetParamCount() == 3 and data.GetParam(1).isdigit() and data.GetParam(2).isdigit():
							Parent.SendDiscordDM(data.User, "Here are the viewers with there join date from {0} to {1} (totally {2}):".format(data.GetParam(1), data.GetParam(2), len(ScriptSettings.viewers)))
							ordered = collections.OrderedDict(sorted(ScriptSettings.viewers.items()))
							message = ""
							for i in range(int(data.GetParam(1)), int(data.GetParam(2))):
								key = GetKeyByIndex(ordered, i)
								message += "{0} ({1})\n".format(key, ordered[key])
							Parent.SendDiscordDM(data.User, message[:-1])
						else:
							Parent.SendDiscordDM(data.User, "Here are all {0} viewers:".format(len(ScriptSettings.viewers)))
							ordered = collections.OrderedDict(sorted(ScriptSettings.viewers.items()))
							message = ""
							for key, time in ordered.iteritems():
								message += "{0} ({1})\n".format(key, time)
							Parent.SendDiscordDM(data.User, message[:-1])
				elif data.Message.lower() == ChatMessages.lower():
					if len(ScriptSettings.messages) == 0:
						Parent.SendDiscordDM(data.User, "There are no welcome messages!")
					else:
						Parent.SendDiscordDM(data.User, "There are {0} welcome messages:".format(len(ScriptSettings.messages)))
						counter = 1
		
						for message in ScriptSettings.messages:
							Parent.SendDiscordDM(data.User, "{0}. {1}".format(str(counter), message))
							counter += 1
		else:
			if data.IsFromTwitch():
				Parent.SendTwitchWhisper(data.User, "You don't have the permission to use this command! ({0})".format(ChatPermission))
			elif data.IsFromDiscord():
				Parent.SendDiscordDM(data.User, "You don't have the permission to use this command! ({0})".format(ChatPermission))
	return

def GetKeyByIndex(dictionary, index):
	counter = 0
	for key, value in dictionary.iteritems():
		if counter == index:
			return key
		counter += 1
	return
		
#---------------------------------------
# Tick
#---------------------------------------
def Tick():
	global ScriptSettings, isEnabled, SendMessages;
	
	if isEnabled:
		viewers = Parent.GetViewerList()
		
		for viewer in viewers:
			try:
				if not viewer in ScriptSettings.viewers:
					if SendMessages:
						for message in ScriptSettings.messages:
							Parent.SendTwitchMessage(message.replace("{viewer}", viewer))
					ScriptSettings.viewers[viewer] = time.strftime("%Y/%m/%d")
					Parent.Log(time.strftime("%H:%M"), viewer + " has joined your stream for the first time!")
			except:
				ScriptSettings.viewers = {}
	return

#---------------------------------------
# SetDefaults Custom User Interface Button
#---------------------------------------
def DeleteViewers():
	global ScriptSettings, SafeQuestion

	if SafeQuestion:
		ScriptSettings.viewers = {}
		Parent.Log(ScriptName, "Deleted all viewers!")
	else:
		Parent.Log(ScriptName, "Please check the checkbox first and press the \"Save Settings\" button before you press the \"Delete ALL Viewers\" button! - Viewers have not been removed!")
	return
	
def ShowViewers():
	global ScriptSettings
	
	if len(ScriptSettings.viewers) == 0:
		Parent.Log(ScriptName, "Your viewer list is empty!")
	else:
		Parent.Log("Join date", "Your {0} viewers:".format(len(ScriptSettings.viewers)))
		ordered = collections.OrderedDict(sorted(ScriptSettings.viewers.items()))
		for viewer, time in ordered.iteritems():
			Parent.Log(time, viewer)
	return

def DeleteViewer():
	global ScriptSettings, ViewerToDelete
	
	if ViewerToDelete.replace(" ", "") != "":
		if ViewerToDelete in ScriptSettings.viewers:
			del ScriptSettings.viewers[ViewerToDelete]
			Parent.Log(ScriptName, "Viewer {0} successfully removed from the list!".format(ViewerToDelete))
			ViewerToDelete = ""
		else:
			Parent.Log(ScriptName, "The list dosen't contains a viewer called {0}".format(ViewerToDelete))
	else:
		Parent.Log(ScriptName, "The textfield was empty! Please ensure that you press the \"Save Settings\" button before you press the \"Delete Viewer\" button!")
	return
	
def ShowMessages():
	global ScriptSettings
	
	try:
		if len(ScriptSettings.messages) == 0:
			Parent.Log(ScriptName, "You don't have any welcome messages!")
		else:
			Parent.Log("Message ID", "{0} Welcome Message(s): ".format(len(ScriptSettings.messages)))
			counter = 1
			
			for message in ScriptSettings.messages:
				Parent.Log(str(counter), message)
				counter += 1
	except:
		ScriptSettings.messages = []
	return