#!/usr/bin/python
# -*- coding: utf-8 -*-
# pylint: disable=invalid-name
"""Extra parameters including a bunch from Nightbot"""
#---------------------------------------
# Libraries and references
#---------------------------------------
from collections import deque
import codecs
import json
import os
import re
import urllib
import datetime
import time
import ctypes
import winsound
import clr
clr.AddReference('System.Windows.Forms')
from System.Windows.Forms import WebBrowser, Form, DockStyle
#---------------------------------------
# [Required] Script information
#---------------------------------------
ScriptName = "CLP (Castorr's Lazy Pack)"
Website = "https://www.twitch.tv/castorr91"
Creator = "Castorr91"
Version = "1.1.0"
Description = "Right click -> insert api key | Extra parameters!"
#---------------------------------------
# Versions
#---------------------------------------
"""
1.1.0
- Fixed use of more than one parameter at once
- Added usercooldown to !sr and !songrequest
- Parsing is now using less built in parameters
- Added options to disable parameters from other bots
- Removed (1) to (9) because they broke built in parameters
- Improved compability for gif links

Version infomation for older versions 
   can be found in the readme.txt
"""
#---------------------------------------
# Variables
#---------------------------------------
settingsFile = os.path.join(os.path.dirname(__file__), "settings.json")
tweetFile = os.path.join(os.path.dirname(__file__), "tweet.txt")
AudioFilesPath = os.path.join(os.path.dirname(__file__), "sounds")
AudioPlaybackQueue = deque()
#---------------------------------------
# Classes
#---------------------------------------
class Settings:
    """" Loads settings from file if file is found if not uses default values"""

    # The 'default' variable names need to match UI_Config
    def __init__(self, settingsFile=None):
        if settingsFile and os.path.isfile(settingsFile):
            with codecs.open(settingsFile, encoding='utf-8-sig', mode='r') as f:
                self.__dict__ = json.load(f, encoding='utf-8-sig')

        else: #set variables if no settings file is found
            self.Nightbot = False
            self.StreamElements = False
            self.DeepBot = False
            self.PhantomBot = False
            self.WizeBot = False
            self.time = "%H:%M:%S"
            self.date = "%d/%m-%Y"
            self.excluded = ""
            self.srMessage = ("{0} in order to request a song you"
                              "need to add a song/video ID, url or a search term")
            self.srEnabled = True
            self.imperial = True
            self.Volume = 50
            self.YTuser = ""
            self.TwitterUser = ""
            self.noRTs = True
            self.TweetURL = True
            self.TweetShort = True
            self.TweetHowLong = True
            self.CTT = "Come join me over at https://www.twitch.tv/$mychannel"
            self.CTTFailed = "Failed to update click to tweet link!"
            self.RandUserApi = "https://decapi.me/twitch/random_user/$mychannel?exclude={0}"
            self.WeatherApi = "http://api.scorpstuff.com/weather.php?units={0}&city="
            self.FollowageApi = "https://beta.decapi.me/twitch/followage/$mychannel/"
            self.FollowdateApi = "https://beta.decapi.me/twitch/followed/$mychannel/"
            self.viewersApi = "https://decapi.me/twitch/viewercount/$mychannel"
            self.viewsApi = "https://decapi.me/twitch/total_views/$mychannel"
            self.AvatarApi = "https://decapi.me/twitch/avatar/"
            self.SubEmotesApi = "https://decapi.me/twitch/subscriber_emotes/$mychannel"
            self.BTTVEmotesApi = "https://decapi.me/bttv/emotes/$mychannel"
            self.FFZEmotesApi = "https://decapi.me/ffz/emotes/$mychannel"
            self.LastYTApi = "https://decapi.me/youtube/latest_video?id="
            self.LastTweetApi = "https://decapi.me/twitter/latest?name="
            self.UrbanApi = "http://api.scorpstuff.com/urbandictionary.php?term="
            self.ageApi = "https://decapi.me/twitch/creation?user="

    # Reload settings on save through UI
    def ReloadSettings(self, data):
        """Reload settings on save through UI"""
        self.__dict__ = json.loads(data, encoding='utf-8-sig')
        return

    # Save settings to files (json and js)
    def SaveSettings(self, settingsFile):
        """Save settings to files (json and js)"""
        with codecs.open(settingsFile, encoding='utf-8-sig', mode='w+') as f:
            json.dump(self.__dict__, f, encoding='utf-8-sig')
        with codecs.open(settingsFile.replace("json", "js"), encoding='utf-8-sig', mode='w+') as f:
            f.write("var settings = {0};".format(json.dumps(self.__dict__, encoding='utf-8-sig')))
        return
#---------------------------------------
# Settings functions
#---------------------------------------
def UpdateSettings():
    """Update settings"""
    with open(m_ConfigFile) as ConfigFile:
        MySet.__dict__ = json.load(ConfigFile, encoding='utf-8-sig')
    return

def SaveSettings(self, settingsFile):
    """Save settings to files (json and js)"""
    with codecs.open(settingsFile, encoding='utf-8-sig', mode='w+') as f:
        json.dump(self.__dict__, f, encoding='utf-8-sig')
    with codecs.open(settingsFile.replace("json", "js"), encoding='utf-8-sig', mode='w+') as f:
        f.write("var settings = {0};".format(json.dumps(self.__dict__, encoding='utf-8-sig')))
    return

def ReloadSettings(jsonData):
    """Reload settings on Save"""

    # Globals
    global MySet

    # Reload saved settings
    MySet.ReloadSettings(jsonData)
    # End of ReloadSettings
    return

#---------------------------------------
# [Optional] UI buttons
#---------------------------------------
def SetDefaults():
    """Set default settings function"""
    # Globals
    global MySet
    winsound.MessageBeep()
    MessageBox = ctypes.windll.user32.MessageBoxW
    returnValue = MessageBox(0, u"You are about to restore the default settings. "
                                "Are you sure you want to continue?"
                             , u"Restore settings?", 4)
    if returnValue == 6:
        # Set defaults by not supplying a settings file
        MySet = Settings()

        # Save defaults back to file
        MySet.SaveSettings(settingsFile)
        MessageBox = ctypes.windll.user32.MessageBoxW
        returnValue = MessageBox(0, u"Settings successfully restored!"
                                 , u"Restored", 0)
    # End of SetDefaults
    return

def timeHelp():
    """Opens a information box with all variables available for date and time formatting"""
    MessageBox = ctypes.windll.user32.MessageBoxW
    MessageBox(0, "\r\n %a - Locale’s abbreviated weekday name."
                  "\r\n %A - Locale’s full weekday name."
                  "\r\n %b - Locale’s abbreviated month name."
                  "\r\n %B - Locale’s full month name."
                  "\r\n %c - Locale’s appropriate date and time representation."
                  "\r\n %d - Day of the month as a decimal number [01,31]."
                  "\r\n %H - Hour (24-hour clock) as a decimal number [00,23]."
                  "\r\n %I - Hour (12-hour clock) as a decimal number [01,12]."
                  "\r\n %j - Day of the year as a decimal number [001,366]."
                  "\r\n %m - Month as a decimal number [01,12]."
                  "\r\n %M - Minute as a decimal number [00,59]."
                  "\r\n %p - Locale’s equivalent of either AM or PM."
                  "\r\n %S - Second as a decimal number [00,61]."
                  "\r\n %U - Week number of the year (Sunday as the first day of the week) as a "
                  "\r\n\tdecimal number [00,53]. All days in a new year preceding the first "
                  "\r\n\tSunday are considered to be in week 0."
                  "\r\n %w - Weekday as a decimal number [0(Sunday),6]."
                  "\r\n %W - Week number of the year (Monday as the first day of the week) as a "
                  "\r\n\tdecimal number [00,53]. All days in a new year preceding the first "
                  "\r\n\tMonday are considered to be in week 0."
                  "\r\n %x - Locale’s appropriate date representation."
                  "\r\n %X - Locale’s appropriate time representation."
                  "\r\n %y - Year without century as a decimal number [00,99]."
                  "\r\n %Y - Year with century as a decimal number."
                  "\r\n %z - Time zone offset indicating a positive/negative time difference from"
                  "\r\n\tUTC/GMT of the form +HHMM or -HHMM, where H represents "
                  "\r\n\tdecimal hour digits and M represents decimal minute digits [-23:59, "
                  "\r\n\t+23:59]."
                  "\r\n %Z - Time zone name (no characters if no time zone exists)."
                  "\r\n %% - A literal '%' character.", "Available format options", 0)
    return

def OpenSoundsFolder():
    """Open specific sound folder"""
    os.startfile(AudioFilesPath)
    return

def OpenReadMe():
    """Open the readme.txt in the scripts folder"""
    location = os.path.join(os.path.dirname(__file__), "README.txt")
    os.startfile(location)
    return

def OpenFilesFolder():
    """Opens the built in files folder"""
    location = os.path.join(os.getcwd(), "Services\\Twitch\\Files\\")
    os.startfile(location)
    return

#---------------------------------------
# [Optional] UI buttons (websites)
#---------------------------------------
def SL():
    """Open Streamlabs homepage"""
    OpenLink("https://www.streamlabs.com/")
    return

def Ideas():
    """Open Streamlabs feature suggestions website"""
    OpenLink("https://ideas.streamlabs.com/")
    return

def Bits():
    """Open twitch bits acceptable use policy"""
    OpenLink("https://www.twitch.tv/p/legal/bits-acceptable-use/")
    return

def Blog():
    """Opens twitch blog in default browser"""
    OpenLink("https://blog.twitch.tv/")
    return

def IRLFAQ():
    """Open twitch IRL FAQ"""
    link = "https://help.twitch.tv/customer/portal/articles/2672652-irl-faq"
    OpenLink(link)
    return

def HelpCenter():
    """Open twitch help center"""
    OpenLink("https://help.twitch.tv/")
    return

def LocateYTID():
    """Function to find YouTube Channel ID!"""
    f = Form()
    f.Text = "YouTube Advanced Account Settings"
    f.Width = 1200
    f.Height = 800
    wb = WebBrowser()
    wb.ScriptErrorsSuppressed = True
    wb.Navigate("https://www.youtube.com/account_advanced")
    wb.Dock = DockStyle.Fill
    f.Controls.Add(wb)
    f.ShowDialog()
    return

def TGuidelines():
    """Open Twitch Community Guidelines"""
    link = "https://www.twitch.tv/p/legal/community-guidelines/"
    OpenLink(link)
    return

def Twitter():
    """Open the users Twitter link!"""
    OpenLink("https://twitter.com/" + MySet.TwitterUser)
    return

def OpenLink(link):
    """Open links through buttons in UI"""
    os.system("explorer " + link)
    return

#---------------------------------------
# [Required] functions
#---------------------------------------
def Init():

    """Data on Load, required function"""
    # Globals
    global MySet
    global followFile
    global lastfollowFile
    global RegSound
    global RegGif
    global RegQuery

    #set path for session follow amount file
    followFile = os.path.join(os.getcwd(), "Services\\Twitch\\Files\\AmountOfFollowers.txt")
    lastfollowFile = os.path.join(os.getcwd(), "Services\\Twitch\\Files\\RecentFollower.txt")

    # Load in saved settings
    MySet = Settings(settingsFile)

    RegGif = re.compile(r"(?:\$gif\([\ ]*(?P<link>[^\"\']+)"
                        r"[\ ]*\,[\ ]*(?P<duration>[^\"\']*)[\ ]*\))", re.U)
    RegSound = re.compile(r"(?:\$sound\([\ ]*(?P<file>[^\"\']+)[\ ]*\))", re.U)
    RegQuery = re.compile(r"(?:\$\(querystring[\ ]*(?P<string>[^\"\']+)[\ ]*\))", re.U)
    # End of Init
    return

def Tick():
    """Required tick function"""
    # Audio file in the queue?
    if AudioPlaybackQueue:
        # Try to playback left most item in queue
        if Parent.PlaySound(AudioPlaybackQueue[0], MySet.Volume*0.01):
            # Pop from queue if has been played
            AudioPlaybackQueue.popleft()
    return

def Execute(data):
    """Required Execute Data function"""
    #check if command is called
    if data.IsChatMessage() and MySet.srEnabled:

        if not (Parent.GetUserCooldownDuration(ScriptName, "!sr", data.User) or Parent.GetUserCooldownDuration(ScriptName, "!songrequest", data.User)):

            #check if enough parameters are there
            paramZero = data.GetParam(0).lower()
            commandCheck = paramZero == "!sr" or paramZero == "!songrequest"
            if commandCheck and data.GetParamCount() < 2:
                if data.IsWhisper():
                    Parent.SendStreamWhisper(data.User, MySet.srMessage.format(data.User))
                    Parent.AddUserCooldown(ScriptName, "!sr", data.User, 100)
                    Parent.AddUserCooldown(ScriptName, "!songrequest", data.User, 100)
                else:
                    Parent.SendStreamMessage(MySet.srMessage.format(data.User))
                    Parent.AddUserCooldown(ScriptName, "!sr", data.User, 100)
                    Parent.AddUserCooldown(ScriptName, "!songrequest", data.User, 100)
    return
#---------------------------------------
# Additional functions
#---------------------------------------
def EnqueueAudioFile(audiofile):
    """ Adds an audio file from the audio folder to the play queue. """
    fullpath = os.path.join(AudioFilesPath, audiofile)
    AudioPlaybackQueue.append(fullpath)
    return

def GetTextFileContent(textfile):
    """Grabs content from textfile"""
    try:
        with codecs.open(textfile, encoding="utf-8-sig", mode="r") as f:
            return f.readline().strip()
    except FileNotFoundError:
        return ""

#---------------------------------------
# Parse functions
#---------------------------------------
def Parse(parseString, userid, username, targetid, targetname, message):
    """Parse function"""

    if MySet.Nightbot:
        parseString = Nightbot(parseString, userid, targetid, message)

    if MySet.StreamElements:
        parseString = StreamElements(parseString, userid, username)

    if MySet.DeepBot:
        parseString = DeepBot(parseString, userid, targetid)

    if MySet.PhantomBot:
        parseString = PhantomBot(parseString, userid, targetid, message)

    if MySet.WizeBot:
        parseString = WizeBot(parseString)

    parseString = NewParameters(parseString, username, targetname, message)
    parseString = CustomParameters(parseString)

    return parseString

def Nightbot(parseString, userid, targetid, message):
    """Parse nightbot parameters if enabled"""

    if "$(user)" in parseString:
        parseString = parseString.replace("$(user)", userid)

    if "$(touser)" in parseString:
        if len(message) > 1:
            parseString = parseString.replace("$(touser)", targetid)
        parseString = parseString.replace("$(touser)", userid)

    if "$(weather " in parseString:
        api = "$readapi(http://api.scorpstuff.com/weather.php?units=metric&city="
        parseString = parseString.replace("$(weather ", api)

    if "$(urlfetch " in parseString:
        parseString = parseString.replace("$(urlfetch ", "$readapi(")

    if "$(count)" in parseString:
        tempString = ("[PARAMETER ERROR: for count to work properly you need to replace $(count) with $count in the command]")
        parseString = parseString.replace("$(count)", tempString)

    if "$(channel)" in parseString:
        parseString = parseString.replace("$(channel)", "$mychannel")

    if "$(query)" in parseString:
        parseString = parseString.replace("$(query)", "$msg")

    if "$(querystring)" in parseString:
        QueryString = urllib.quote_plus(message)
        parseString = parseString.replace("$(querystring)", QueryString)

    if "$(time " in parseString:
        parseString = parseString.replace("$time ", "$readapi(https://beta.decapi.me/misc/time?timezone=")

    return parseString

def StreamElements(parseString, userid, username):
    """Parse parameters from StreamElements"""
    #-----------------------------------------------
    # Parameters from StreamElements
    #-----------------------------------------------
    if "${user}" in parseString:
        parseString = parseString.replace("${user}", userid)

    if "${user.name}" in parseString:
        parseString = parseString.replace("${user.name}", username)

    if "${user.points}" in parseString:
        parseString = parseString.replace("${user.points}", "$points")

    if "${user.points_rank}" in parseString:
        parseString = parseString.replace("${user.points_rank}", "$pointspos")

    if "${user.time_online}" in parseString:
        parseString = parseString.replace("${user.time_online}", "$hours")

    if "${user.time_online_rank}" in parseString:
        parseString = parseString.replace("${user.time_online_rank}", "$hourspos")

    if "${sender}" in parseString:
        parseString = parseString.replace("${sender}", userid)

    if "${source}" in parseString:
        parseString = parseString.replace("${source}", userid)

    if "${title}" in parseString:
        parseString = parseString.replace("${title}", "$mystatus")

    if "${status}" in parseString:
        parseString = parseString.replace("${status}", "$mystatus")

    if "${game}" in parseString:
        parseString = parseString.replace("${game}", "$mygame")

    if "${pointsname}" in parseString:
        parseString = parseString.replace("${pointsname}", "$currencyname")

    if "$$mychannel" in parseString:
        parseString = parseString.replace("$$mychannel", "$mychannel")

    if "${channel.viewers}" in parseString:
        a = "$readapi("
        api = a.__add__(MySet.viewersApi).__add__(")")
        parseString = parseString.replace("${channel.viewers}", api)

    if "${channel.views}" in parseString:
        a = "$readapi("
        api = a.__add__(MySet.viewsApi).__add__(")")
        parseString = parseString.replace("${channel.views}", api)

    if "${channel.followers}" in parseString:
        parseString = parseString.replace("${channel.followers}", "$followercount")

    if "${channel.subs}" in parseString:
        parseString = parseString.replace("${channel.subs}", "$subcount")

    if "${random.chatter}" in parseString:
        parseString = parseString.replace("${random.chatter}", "$randuser")

    if "${uptime}" in parseString:
        parseString = parseString.replace("${uptime}", "$uptime")

    if "${count" in parseString:
        parseString = parseString.replace("${count", "[PARAMETER ERROR: for count to work properly you need to replace ${count} with $count in the command]")

    if "${getcount" in parseString:
        parseString = parseString.replace("${getcount", "[PARAMETER ERROR: for count to work properly you need to replace ${getcount} with $checkcount(COMMAND_NAME) in the command]")
    return parseString

def DeepBot(parseString, userid, targetid):
    """Parse deepbot parameters"""
    if "@user@" in parseString:
        parseString = parseString.replace("@user@", userid)

    if "@viewers@" in parseString:
        a = "$readapi("
        api = a.__add__(MySet.viewersApi).__add__(")")
        parseString = parseString.replace("@viewers@", api)

    if "@time@" in parseString:
        parseString = parseString.replace("@time@", "")

    if "@time24@" in parseString:
        parseString = parseString.replace("@time24@", "")

    if "@title@" in parseString:
        parseString = parseString.replace("@title@", "$mystatus")

    if "@pointsname@" in parseString:
        parseString = parseString.replace("@pointsname@", "$currencyname")

    if "@target@" in parseString:
        parseString = parseString.replace("@target@", targetid)

    if "@pointstolevelup@" in parseString:
        parseString = parseString.replace("@pointstolevelup@", "$nxtrankreq")

    if "@randomuser@" in parseString:
        parseString = parseString.replace("@randomuser@", "$randuser")

    if "@points@" in parseString:
        parseString = parseString.replace("@points@", "$points")

    if "@intpoints@" in parseString:
        parseString = parseString.replace("@intpoints@", "$pointstext")

    if "@hrstolevelup@" in parseString:
        parseString = parseString.replace("@hrstolevelup@", "$nxtrankreq")

    if "@hours@" in parseString:
        parseString = parseString.replace("@hours@", "$hours")

    if "@getcounter@" in parseString:
        parseString = parseString.replace("@getcount@", "[PARAMETER ERROR: for getcounter to work properly you need to replace @getcount@[!command] with $checkcount(!command) in the command]")

    if "@game@" in parseString:
        parseString = parseString.replace("@game@", "$mygame")

    if "@followers@" in parseString:
        parseString = parseString.replace("@followers@", "$followercount")

    if "@counter@" in parseString:
        parseString = parseString.replace("@counter@", "[PARAMETER ERROR: for getcounter to work properly you need to replace @counter@[!command] with $count in the command]")

    if "@followdate@" in parseString:
        a = "$readapi("
        api = a.__add__(MySet.FollowdateApi).__add__("$userid)")
        parseString = parseString.replace("@followdate@", api)

    if "@subs@" in parseString:
        parseString = parseString.replace("@subs@", "$subcount")

    if "@customapi@" in parseString:
        parseString = parseString.replace("@customapi@", "$readapi[To fully get api functional you have to replace the [] with () around the api url]")

    return parseString

def PhantomBot(parseString, userid, targetid, message):
    """Parse PhantomBot parameters!"""
    if "(sender)" in parseString:
        parseString = parseString.replace("(sender)", data.User)

    if "(@sender)" in parseString:
        parseString = parseString.replace("(@sender)", "@$userid")

    if "(touser)" in parseString:
        if len(message) > 1:
            parseString = parseString.replace("(touser)", targetid)
        parseString = parseString.replace("(touser)", userid)

    if "(pointtouser)" in parseString:
        if len(message) > 1:
            parseString = parseString.replace("(pointtouser)", "$target ->")
        parseString = parseString.replace("(pointtouser)", "$userid ->")

    if "(currenttime)" in parseString:
        parseString = parseString.replace("(currenttime)", "$time")

    if "(#)" in parseString:
        parseString = parseString.replace("(#)", "$randnum(0,100)")

    if "(random)" in parseString:
        parseString = parseString.replace("(random)", "$randuser")

    if "(pointname)" in parseString:
        parseString = parseString.replace("(pointname)", "$currencyname")

    if "(uptime)" in parseString:
        parseString = parseString.replace("(uptime)", "$uptime")

    if "(game)" in parseString:
        parseString = parseString.replace("(game)", "$mygame")

    if "(status)" in parseString:
        parseString = parseString.replace("(status)", "$mystatus")

    if "(viewers)" in parseString:
        a = "$readapi("
        api = a.__add__(MySet.viewersApi).__add__(")")
        parseString = parseString.replace("(viewers)", api)

    if "(follows)" in parseString:
        parseString = parseString.replace("(follows)", "$followercount")

    if "(count)" in parseString:
        parseString = parseString.replace("(count)", "[PARAMETER ERROR: for count to work properly "
                                   "you need to replace (count) with $count in the command]")

    if "(senderrank)" in parseString:
        parseString = parseString.replace("(senderrank)", "$rank")

    if "(readfile " in parseString:
        parseString = parseString.replace("(readfile ", "$readline(")

    if "(readfilerand " in parseString:
        parseString = parseString.replace("(readfilerand ", "$readrandline(")

    if "(echo)" in parseString:
        parseString = parseString.replace("(echo)", "$msg")

    if "(titleinfo)" in parseString:
        parseString = parseString.replace("(titleinfo)", "Current title: $mystatus Uptime: $uptime")

    if "(gameinfo)" in parseString:
        parseString = parseString.replace("(gameinfo)", "Current game: $mygame Playtime: $uptime")

    if "(channelname)" in parseString:
        parseString = parseString.replace("(channelname)", "$mychannel")

    if "(subscribers)" in parseString:
        parseString = parseString.replace("(subscribers)", "$subcount")

    if "(subscribers)" in parseString:
        parseString = parseString.replace("(subscribers)", "$subcount")

    if "(age)" in parseString:
        if len(message) > 1:
            parseString = parseString.replace("(age)", MySet.ageApi.__add__("$target"))
        parseString = parseString.replace("(age)", MySet.ageApi.__add__("$user"))
    return parseString

def WizeBot(parseString):
    """Parse WizeBot parameters"""
    if "$(channel_name)" in parseString:
        parseString = parseString.replace("$(channel_name)", "$mychannel")

    if "$(random_viewer)" in parseString:
        parseString = parseString.replace("$(random_viewer)", "$randuser")

    if "$random(" in parseString:
        parseString = parseString.replace("$random(", "$randnum(")

    if "$(current_game)" in parseString:
        parseString = parseString.replace("$(current_game)", "$mygame")

    if "$(current_viewers)" in parseString:
        a = "$readapi("
        api = a.__add__(MySet.viewersApi).__add__(")")
        parseString = parseString.replace("$(current_viewers)", api)

    if "$(todayFollow)" in parseString:
        sessionFollows = GetTextFileContent(followFile)
        parseString = parseString.replace("$(todayFollow)", sessionFollows)

    if "$(last_follow_name)" in parseString:
        lastFollow = GetTextFileContent(lastfollowFile)
        parseString = parseString.replace("$(last_follow_name)", lastFollow)

    if "$(session_followers)" in parseString:
        sessionFollows = GetTextFileContent(followFile)
        parseString = parseString.replace("$(session_followers)", sessionFollows)

    if "$(follow_count)" in parseString:
        parseString = parseString.replace("$(follow_count)", "$followercount")

    if "$(sub_count)" in parseString:
        parseString = parseString.replace("$(sub_count)", "$subcount")
    return parseString

def NewParameters(parseString, username, targetname, message):
    """Parse new parameters"""
    if "$weather(" in parseString:
        a = "$readapi("
        api = a.__add__(MySet.WeatherApi)
        if MySet.imperial:
            parseString = parseString.replace("$weather(", api.format("imperial"))
        parseString = parseString.replace("$weather(", api.format("metric"))

    if "$followage(" in parseString:
        a = "$readapi("
        link = MySet.FollowageApi.replace("$mychannel", Parent.GetChannelName())
        api = a.__add__(link)
        parseString = parseString.replace("$followage(", api)

    if "$followdate(" in parseString:
        a = "$readapi("
        link = MySet.FollowdateApi.replace("$mychannel", Parent.GetChannelName())
        api = a.__add__(link)
        parseString = parseString.replace("$followdate(", api)

    if "$viewers" in parseString:
        a = "$readapi("
        link = MySet.viewersApi.replace("$mychannel", Parent.GetChannelName())
        api = a.__add__(link).__add__(")")
        parseString = parseString.replace("$viewers", api)

    if "$views" in parseString:
        a = "$readapi("
        link = MySet.viewsApi.replace("$mychannel", Parent.GetChannelName())
        api = a.__add__(link).__add__(")")
        parseString = parseString.replace("$views", api)

    if "$avatar(" in parseString:
        a = "$readapi("
        api = a.__add__(MySet.AvatarApi)
        parseString = parseString.replace("$avatar(", api)

    if "$subemotes" in parseString:
        a = "$readapi("
        link = MySet.SubEmotesApi.replace("$mychannel", Parent.GetChannelName())
        api = a.__add__(link).__add__(")")
        parseString = parseString.replace("$subemotes", api)

    if "$bttvemotes" in parseString:
        a = "$readapi("
        link = MySet.BTTVEmotesApi.replace("$mychannel", Parent.GetChannelName())
        api = a.__add__(link).__add__(")")
        parseString = parseString.replace("$bttvemotes", api)

    if "$ffzemotes" in parseString:
        a = "$readapi("
        link = MySet.FFZEmotesApi.replace("$mychannel", Parent.GetChannelName())
        api = a.__add__(link).__add__(")")
        parseString = parseString.replace("$ffzemotes", api)

    if "$latestyt" in parseString:
        a = "$readapi("
        api = a.__add__(MySet.LastYTApi).__add__(MySet.YTuser).__add__(")")
        parseString = parseString.replace("$latestyt", api)

    if "$latesttweet" in parseString:
        a = "$readapi("
        api = a.__add__(MySet.LastTweetApi).__add__(MySet.TwitterUser)
        if MySet.noRTs:
            api = api.__add__("&no_rts")
        if MySet.TweetURL:
            api = api.__add__("&url")
        if MySet.TweetShort:
            api = api.__add__("&shorten")
        if MySet.TweetHowLong:
            api = api.__add__("&howlong")
        api = api.__add__(")")
        parseString = parseString.replace("$latesttweet", api)

    if "$urban(" in parseString:
        a = "$readapi("
        api = a.__add__(MySet.UrbanApi)
        parseString = parseString.replace("$urban(", api)

    if "$age" in parseString:
        a = "$readapi("
        link = MySet.ageApi.replace("$mychannel", Parent.GetChannelName())
        if len(message) > 1:
            api = a.__add__(link).__add__(targetname + ")")
            parseString = parseString.replace("$age", api)
        api = a.__add__(link).__add__(username + ")")
        parseString = parseString.replace("$age", api)

    if "$ctt" in parseString:
        link = MySet.CTT.replace("$mychannel", Parent.GetChannelName())
        urlEnd = urllib.quote_plus(link)
        url = "https://twitter.com/intent/tweet?text=".__add__(urlEnd)
        if MySet.TweetShort:
            url = "$readapi(http://tinyurl.com/api-create.php?url={0})".format(url)
        parseString = parseString.replace("$ctt", url)

    if "$setctt" in parseString:
        if len(message) > 1:
            MySet.CTT = message
            SaveSettings(MySet, settingsFile)
            urlEnd = urllib.quote_plus(MySet.CTT)
            url = "https://twitter.com/intent/tweet?text=".__add__(urlEnd)
            if MySet.TweetShort:
                url = "$readapi(http://tinyurl.com/api-create.php?url={0})".format(url)
            parseString = parseString.replace("$setctt", url)
        parseString = parseString.replace("$setctt", MySet.CTTFailed)

    if "$sessionfollows" in parseString:
        sessionFollows = GetTextFileContent(followFile)
        parseString = parseString.replace("$sessionfollows", sessionFollows)

    if "$lastfollow" in parseString:
        lastFollow = GetTextFileContent(lastfollowFile)
        parseString = parseString.replace("$lastfollow", lastFollow)

    if "$torand" in parseString:
        if len(message) > 1:
            parseString = parseString.replace("$torand", target)
        parseString = parseString.replace("$torand", "$randuser")

    if "$sound" in parseString:
        result = RegSound.search(parseString)
        if result:
            fullSound = result.group(0)
            Soundfile = result.group("file")
            fullpath = os.path.join(AudioFilesPath, Soundfile)
            if fullpath and os.path.isfile(fullpath):
                EnqueueAudioFile(Soundfile)
                parseString = parseString.replace(fullSound, "")
            parseString = parseString.replace(fullSound, "[ERROR: Soundfile not found]")

    if "$gif" in parseString:

        result = RegGif.search(parseString)
        if result:
            fullGif = result.group(0)
            GifLink = result.group("link")

            gifDuration = int(result.group("duration"))
            f = {"duration": gifDuration*1000, "link": GifLink}
            Parent.BroadcastWsEvent("EVENT_GIF", json.dumps(f, encoding='utf-8-sig'))

            parseString = parseString.replace(fullGif, "")

    return parseString

def CustomParameters(parseString):
    """Custom versions of built in parameters"""
    if "$ctime" in parseString:
        myTime = time.strftime(MySet.time, time.localtime(time.time()))
        parseString = parseString.replace("$ctime", myTime)

    if "$cdate" in parseString:
        myDate = datetime.datetime.now().strftime(MySet.date)
        parseString = parseString.replace("$cdate", myDate)

    if "$cranduser" in parseString:
        a = "$readapi("
        link = MySet.RandUserApi.replace("$mychannel", Parent.GetChannelName())
        api = a.__add__(link).__add__(")")
        parseString = parseString.replace("$cranduser", api.format(MySet.excluded))

    if "$ctarget" in parseString:
        parseString = parseString.replace("$ctarget", target.replace("@", ""))

    return parseString
